<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Exception;
use Error;
use Spatie\Permission\Models\Role;

class InitProgram extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:init-program';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Initialize the program by running migrations and creating a default user';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->info('Starting program initialization...');

        // Run migrations
        $this->info('Running migrations...');
        Artisan::call('migrate:fresh', [], $this->getOutput());

        $this->info('Migrations completed successfully.');

        // Ask for user details
        $username = $this->ask('What is the username?');
        $password = $this->secret('What is the password?');

        $this->info('Creating user...');

        $role = Role::create([
            "name" => "SUPERADMIN",
            "created_by" => 1
        ]);

        try {
            $user = new User();

            $user->name = is_string($username) ? (string) $username : '';
            $user->username = is_string($username) ? (string) $username : '';
            $user->password = bcrypt(is_string($password) ? (string) $password : '');
            $user->created_by = 1;

            if ($user->save()) {
                $this->info("User '{$username}' created successfully with ID: {$user->id}");
                $this->newLine();
                $this->info('✓ Program initialization completed!');

                $user->assignRole($role);
            }
        } catch (Exception | Error $e) {
            Log::error('Console Error: ' . $e);
            $this->error('Failed to create user.');
        }
    }
}
