<?php

namespace App\Facades;

use Illuminate\Support\Facades\Facade;

/**
 * Helper Facade
 *
 * @method static array getModelLabels(string $modelClass)
 * @method static string getAttributeLabel(string $modelClass, string $attribute)
 * @method static string modelLabel(mixed $model, string $attribute)
 * @method static array toDropdownOptions($data, string $nameField, string $valueField)
 * @method static string formatter($value) Simple number formatter - adds thousand separators
 * @method static float parser($formattedValue) Simple number parser - removes thousand separators
 * @method static string formatNumber($value, int $decimals = 0) Alias for formatter()
 * @method static float parseNumber($formattedValue) Alias for parser()
 * @method static string formatCurrency($value, int $decimals = 0) Format currency with Rp prefix
 * @method static bool checkPermission(string $permission)
 *
 * @see \App\Helpers\Helpers
 */
class Helper extends Facade
{
  /**
   * Get the registered name of the component.
   *
   * @return string
   */
  protected static function getFacadeAccessor()
  {
    return 'helper';
  }
}
