<?php

namespace App\Guards;

use App\Models\DeliverOrderDetail;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;

class DriverGuard implements Guard
{
    protected $request;
    protected $deliveryOrderDetail;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function check()
    {
        return !is_null($this->user());
    }

    public function guest()
    {
        return !$this->check();
    }

    public function user()
    {
        if (!is_null($this->deliveryOrderDetail)) {
            return $this->deliveryOrderDetail;
        }

        $token = $this->getTokenFromRequest();

        if (!$token) {
            return null;
        }

        $deliveryOrderDetail = DeliverOrderDetail::with(['driver', 'deliveryOrder', 'truck', 'detail'])
            ->where('driver_access_token', $token)
            ->whereIn('status', ['pending', 'loading', 'unloading', 'ondelivery', 'onhold'])
            ->first();

        if (!$deliveryOrderDetail) {
            return null;
        }

        // Check if token is expired (optional)
        if ($deliveryOrderDetail->token_expires_at && $deliveryOrderDetail->token_expires_at->isPast()) {
            return null;
        }

        $this->deliveryOrderDetail = $deliveryOrderDetail;

        return $this->deliveryOrderDetail;
    }

    public function id()
    {
        if ($user = $this->user()) {
            return $user->id;
        }
    }

    public function validate(array $credentials = [])
    {
        if (empty($credentials['token'])) {
            return false;
        }

        $deliveryOrderDetail = DeliverOrderDetail::where('driver_access_token', $credentials['token'])
            ->whereIn('status', ['pending', 'loading', 'unloading', 'ondelivery', 'onhold'])
            ->first();

        if (!$deliveryOrderDetail) {
            return false;
        }

        $this->deliveryOrderDetail = $deliveryOrderDetail;

        return true;
    }

    public function hasUser()
    {
        return !is_null($this->deliveryOrderDetail);
    }

    public function setUser(Authenticatable $user)
    {
        $this->deliveryOrderDetail = $user;
    }

    protected function getTokenFromRequest()
    {
        // Check query parameter first
        $token = $this->request->query('token');

        if (!$token) {
            // Check header as fallback
            $token = $this->request->bearerToken();
        }

        return $token;
    }
}
