<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\DeliverOrderDetail;

class DriverDashboardController extends Controller
{
    /**
     * Display driver dashboard
     */
    public function index(Request $request)
    {
        $deliveryOrderDetail = Auth::guard('driver')->user();

        if (!$deliveryOrderDetail) {
            return response()->json([
                'message' => 'Token tidak valid atau sudah kadaluarsa.'
            ], 401);
        }

        return view('driver.dashboard', [
            'deliveryOrderDetail' => $deliveryOrderDetail,
            'driver' => $deliveryOrderDetail->driver,
            'deliveryOrder' => $deliveryOrderDetail->deliveryOrder,
            'truck' => $deliveryOrderDetail->truck,
            'transactionDetail' => $deliveryOrderDetail->detail,
        ]);
    }

    /**
     * Update delivery status
     */
    public function updateStatus(Request $request)
    {
        $deliveryOrderDetail = Auth::guard('driver')->user();

        if (!$deliveryOrderDetail) {
            return response()->json([
                'message' => 'Token tidak valid atau sudah kadaluarsa.'
            ], 401);
        }

        $request->validate([
            'status' => 'required|in:loading,unloading,ondelivery,onhold,finish'
        ]);

        $deliveryOrderDetail->update([
            'status' => $request->status,
            'updated_by' => $deliveryOrderDetail->id_driver
        ]);

        // If status is finish, optionally expire the token
        if ($request->status === 'finish') {
            $deliveryOrderDetail->update([
                'token_expires_at' => now()
            ]);
        }

        return response()->json([
            'success' => true,
            'message' => 'Status berhasil diperbarui',
            'data' => $deliveryOrderDetail->fresh()
        ]);
    }

    /**
     * Get current delivery information
     */
    public function getDeliveryInfo(Request $request)
    {
        $deliveryOrderDetail = Auth::guard('driver')->user();

        if (!$deliveryOrderDetail) {
            return response()->json([
                'message' => 'Token tidak valid atau sudah kadaluarsa.'
            ], 401);
        }

        return response()->json([
            'success' => true,
            'data' => [
                'delivery_order_detail' => $deliveryOrderDetail,
                'driver' => $deliveryOrderDetail->driver,
                'delivery_order' => $deliveryOrderDetail->deliveryOrder,
                'truck' => $deliveryOrderDetail->truck,
                'transaction_detail' => $deliveryOrderDetail->detail,
            ]
        ]);
    }
}
