<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class AuthenticateDriver
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $guard = Auth::guard('driver');

        if (!$guard->check()) {
            return response()->json([
                'message' => 'Token tidak valid atau sudah kadaluarsa. Silakan hubungi admin untuk mendapatkan link baru.'
            ], 401);
        }

        return $next($request);
    }
}
