<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Context;
use Symfony\Component\HttpFoundation\Response;

class LogContextMiddleware
{
    /**
     * Handle an incoming request and add context data.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Add request metadata to Context for logging and exception tracking
        Context::add([
            'url'     => $request->fullUrl(),
            'method'  => $request->method(),
            'user_id' => Auth::id() ?? 'guest',
            'ip'      => $request->ip(),
            'payload' => $request->except(['password', 'password_confirmation', 'token', '_token']),
        ]);

        return $next($request);
    }
}
