<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ConfigRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $configId = $this->route('config');

        return [
            'key' => [
                'required',
                'string',
                'max:255',
                Rule::unique('configs', 'key')->ignore($configId)->whereNull('deleted_at'),
            ],
            'value' => 'nullable|string',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string, string>
     */
    public function attributes(): array
    {
        return [
            'key' => 'key',
            'value' => 'value',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'key.required' => 'The key field is required.',
            'key.unique' => 'A config with this key already exists.',
            'key.max' => 'The key may not be greater than 255 characters.',
        ];
    }
}
