<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class PriceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $priceId = $this->route('price');

        return [
            'id_route' => 'required|exists:routes,id',
            'id_loadout' => 'required|exists:truck_loadouts,id',
            'id_customer' => 'nullable|exists:customers,id',
            'price' => 'required|numeric|min:0',
            'notes' => 'nullable|string|max:255',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string, string>
     */
    public function attributes(): array
    {
        return [
            'id_route' => 'route',
            'id_loadout' => 'loadout',
            'id_customer' => 'customer',
            'price' => 'price',
            'notes' => 'notes',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'id_route.required' => 'The route field is required.',
            'id_route.exists' => 'The selected route is invalid.',
            'id_loadout.required' => 'The loadout field is required.',
            'id_loadout.exists' => 'The selected loadout is invalid.',
            'id_customer.exists' => 'The selected customer is invalid.',
            'price.required' => 'The price field is required.',
            'price.numeric' => 'The price must be a number.',
            'price.min' => 'The price must be at least 0.',
        ];
    }

    /**
     * Prepare the data for validation.
     * Remove thousand separators from formatted numbers
     */
    protected function prepareForValidation(): void
    {
        if ($this->has('price') && $this->price !== null && $this->price !== '') {
            $this->merge([
                'price' => \App\Helpers\Helpers::parser($this->price),
            ]);
        }
    }
}
