<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class TruckTypeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $truckTypeId = $this->route('truck_type');

        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('truck_types', 'name')->ignore($truckTypeId)->whereNull('deleted_at'),
            ],
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string, string>
     */
    public function attributes(): array
    {
        return [
            'name' => 'truck type name',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'name.required' => 'The truck type name field is required.',
            'name.unique' => 'A truck type with this name already exists.',
            'name.max' => 'The truck type name may not be greater than :max characters.',
        ];
    }
}
