<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Account extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_category',
        'id_type',
        'name',
        'code',
        'nature',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function category()
    {
        return $this->belongsTo(AccountCategory::class, 'id_category');
    }

    public function type()
    {
        return $this->belongsTo(AccountType::class, 'id_type');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
