<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\LogsActivityWithDetails;

class AccountJournal extends Model
{
    use LogsActivityWithDetails;

    protected $fillable = [
        'id_journal',
        'id_accounts',
        'code',
        'credit',
        'debit',
        'description',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * Get attributes to log - exclude parent foreign key.
     */
    protected function getLogAttributes(): array
    {
        // Exclude parent foreign key: id_journal (this is handled by parent observer)
        return array_diff($this->fillable, ['id_journal']);
    }

    /**
     * Get the options for logging activity.
     * Disable automatic logging for detail models - parent observer handles it.
     */
    public function getActivitylogOptions(): \Spatie\Activitylog\LogOptions
    {
        return \Spatie\Activitylog\LogOptions::defaults()
            ->logOnly([]) // Don't log anything automatically
            ->dontSubmitEmptyLogs();
    }

    /**
     * Get attribute labels for activity log.
     */
    public function getAttributeLabels(): array
    {
        return [
            'id_accounts' => 'Account',
            'code' => 'Code',
            'credit' => 'Credit',
            'debit' => 'Debit',
            'description' => 'Description',
        ];
    }

    public function journal()
    {
        return $this->belongsTo(Journal::class, 'id_journal');
    }

    public function account()
    {
        return $this->belongsTo(Account::class, 'id_accounts');
    }

    public function accounts()
    {
        return $this->belongsTo(Account::class, 'id_accounts');
    }
}
