<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Customer extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'full_name',
        'phone',
        'address',
        'email',
        'pic_name',
        'pic_phone',
        'is_ppn',
        'is_pph',
        'npwp_no',
        'term_of_payment',
        'credit_limit',
        'status',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'is_ppn' => 'boolean',
        'is_pph' => 'boolean',
        'status' => 'boolean',
        'created_at' => 'datetime',
    ];

    public function quotations()
    {
        return $this->hasMany(Transaction::class, 'id_customer')->where('type', 'quotation')->withTrashed();
    }

    public function salesOrders()
    {
        return $this->hasMany(Transaction::class, 'id_customer')->where('type', 'salesorder')->withTrashed();
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
