<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class DeliveryOrderFile extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_delivery_detail_log_status',
        'name',
        'type',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function deliveryOrderStatusLog()
    {
        return $this->belongsTo(DeliveryOrderStatusLog::class, 'id_delivery_detail_log_status');
    }
}
