<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class DeliveryOrderStatusLog extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_delivery_order_detail',
        'status',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function deliveryOrderDetail()
    {
        return $this->belongsTo(DeliverOrderDetail::class, 'id_delivery_order_detail');
    }
}
