<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Driver extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'code',
        'full_name',
        'nick_name',
        'phone',
        'address',
        'identity_number',
        'license_number',
        'kk_number',
        'bpjs_number',
        'identity_file',
        'license_file',
        'license_type',
        'license_date',
        'kk_file',
        'photo_file',
        'skck_file',
        'bank_name',
        'bank_owner_name',
        'bank_no',
        'joined_date',
        'status',
        'notes',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'joined_date' => 'date',
        'license_date' => 'date',
        'created_at' => 'datetime',
    ];

    private $statusColors = [
        'active' => 'success',
        'resigned' => 'secondary',
        'blacklist' => 'black',
    ];

    public function getStatusColor()
    {
        return $this->statusColors[$this->status];
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
