<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Invoice extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'code',
        'invoice_date',
        'total',
        'total_discount',
        'total_ppn',
        'total_pph',
        'grand_total',
        'status',
        'id_payment_account',
        'notes',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'created_at' => 'datetime',
    ];

    /**
     * Get attributes to log - exclude calculated fields.
     */
    protected function getLogAttributes(): array
    {
        // Exclude calculated fields: total, total_discount, total_ppn, total_pph, grand_total
        return array_diff($this->fillable, ['total', 'total_discount', 'total_ppn', 'total_pph', 'grand_total']);
    }

    public function paymentAccount()
    {
        return $this->belongsTo(Account::class, 'id_payment_account');
    }
}
