<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class InvoiceDetail extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_invoice',
        'id_transaction',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * Get attributes to log - exclude parent foreign key.
     */
    protected function getLogAttributes(): array
    {
        // Exclude parent foreign key: id_invoice (this is handled by parent observer)
        return array_diff($this->fillable, ['id_invoice']);
    }

    /**
     * Get the options for logging activity.
     * Disable automatic logging for detail models - parent observer handles it.
     */
    public function getActivitylogOptions(): \Spatie\Activitylog\LogOptions
    {
        return \Spatie\Activitylog\LogOptions::defaults()
            ->logOnly([]) // Don't log anything automatically
            ->dontSubmitEmptyLogs();
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'id_invoice');
    }

    public function transaction()
    {
        return $this->belongsTo(Transaction::class, 'id_transaction');
    }
}
