<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Journal extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'code',
        'date',
        'reference_type',
        'reference_id',
        'description',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'date' => 'date:Y-m-d',
        'created_at' => 'datetime',
    ];

    public function accountJournals()
    {
        return $this->hasMany(AccountJournal::class, 'id_journal');
    }

    /**
     * Get attribute labels for activity log.
     */
    public function getAttributeLabels(): array
    {
        return [
            'code' => 'Code',
            'date' => 'Date',
            'reference_type' => 'Reference Type',
            'reference_id' => 'Reference ID',
            'description' => 'Description',
        ];
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
