<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Price extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_route',
        'id_loadout',
        'id_customer',
        'price',
        'notes',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function route()
    {
        return $this->belongsTo(Route::class, 'id_route');
    }

    public function loadout()
    {
        return $this->belongsTo(TruckLoadout::class, 'id_loadout');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'id_customer');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
