<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Route extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_origin',
        'id_destination',
        'distance',
        'duration',
        'toll',
        'pocket_money_1',
        'pocket_money_2',
        'pocket_money_3',
        'bonus',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function origin()
    {
        return $this->belongsTo(Location::class, 'id_origin');
    }

    public function destination()
    {
        return $this->belongsTo(Location::class, 'id_destination');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
