<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class TransactionDetail extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_transaction',
        'id_origin',
        'origin_name',
        'id_destination',
        'destination_name',
        'id_loadout',
        'price',
        'pocket_money_1',
        'pocket_money_2',
        'pocket_money_3',
        'bonus',
        'sub_total',
        'quantity',
        'origin_action',
        'destination_action',
        'notes',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * Get attributes to log - exclude calculated fields.
     */
    protected function getLogAttributes(): array
    {
        // Exclude calculated field: sub_total
        // Exclude id_transaction since parent observer handles detail logging
        // Include origin_name and destination_name for historical tracking
        return array_diff($this->fillable, ['sub_total', 'id_transaction']);
    }

    /**
     * Get the options for logging activity.
     * Disable automatic logging for detail models - parent observer handles it.
     */
    public function getActivitylogOptions(): \Spatie\Activitylog\LogOptions
    {
        return \Spatie\Activitylog\LogOptions::defaults()
            ->logOnly([]) // Don't log anything automatically
            ->dontSubmitEmptyLogs();
    }

    public function transaction()
    {
        return $this->belongsTo(Transaction::class, 'id_transaction');
    }

    public function origin()
    {
        return $this->belongsTo(Location::class, 'id_origin');
    }

    public function destination()
    {
        return $this->belongsTo(Location::class, 'id_destination');
    }

    public function loadout()
    {
        return $this->belongsTo(TruckLoadout::class, 'id_loadout');
    }
}
