<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\LogsActivityWithDetails;

class Truck extends Model
{
    use SoftDeletes, LogsActivityWithDetails;

    protected $fillable = [
        'id_type',
        'code',
        'brand',
        'body_no',
        'machine_no',
        'vehicle_year',
        'stnk_owner',
        'kir_name',
        'license_plate',
        'tax_date',
        'kir_date',
        'stnk_date',
        'kir_file',
        'bpkb_file',
        'stnk_file',
        'credit_start_date',
        'credit_end_date',
        'cctv_gps_no',
        'gps_contact',
        'note',
        'created_by',
        'updated_by',
        'deleted_by',
    ];

    protected $casts = [
        'tax_date' => 'date',
        'kir_date' => 'date',
        'stnk_date' => 'date',
        'credit_start_date' => 'date',
        'credit_end_date' => 'date',
        'created_at' => 'datetime',
    ];

    public function type()
    {
        return $this->belongsTo(TruckType::class, 'id_type');
    }

    /**
     * Get attribute labels for activity log.
     */
    public function getAttributeLabels(): array
    {
        return  [
            'id_type' => 'Truck Type',
            'code' => 'Code',
            'brand' => 'Brand',
            'body_no' => 'Body Number',
            'machine_no' => 'Machine Number',
            'vehicle_year' => 'Vehicle Year',
            'stnk_owner' => 'STNK Owner',
            'kir_name' => 'KIR Name',
            'license_plate' => 'License Plate',
            'tax_date' => 'Tax Date',
            'kir_date' => 'KIR Date',
            'stnk_date' => 'STNK Date',
            'kir_file' => 'KIR File',
            'bpkb_file' => 'BPKB File',
            'stnk_file' => 'STNK File',
            'credit_start_date' => 'Credit Start Date',
            'credit_end_date' => 'Credit End Date',
            'cctv_gps_no' => 'CCTV/GPS Number',
            'gps_contact' => 'GPS Contact',
            'note' => 'Note',
        ];
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}
