<?php

namespace App\Providers;

use App\Models\Account;
use App\Models\AccountCategory;
use App\Models\AccountType;
use App\Models\Customer;
use App\Models\Driver;
use App\Models\Location;
use App\Models\Price;
use App\Models\Role;
use App\Models\Route;
use App\Models\Transaction;
use App\Models\Truck;
use App\Models\TruckLoadout;
use App\Models\TruckType;
use App\Models\User;
use App\Repositories\AccountCategoryRepository;
use App\Repositories\AccountRepository;
use App\Repositories\AccountTypeRepository;
use App\Repositories\CustomerRepository;
use App\Repositories\DriverRepository;
use App\Repositories\LocationRepository;
use App\Repositories\PriceRepository;
use App\Repositories\QuotationRepository;
use App\Repositories\RoleRepository;
use App\Repositories\RouteRepository;
use App\Repositories\TruckLoadoutRepository;
use App\Repositories\TruckRepository;
use App\Repositories\TruckTypeRepository;
use App\Repositories\UserRepository;
use Illuminate\Support\ServiceProvider;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(CustomerRepository::class, function ($app) {
            return new CustomerRepository(new Customer());
        });

        $this->app->singleton(TruckTypeRepository::class, function ($app) {
            return new TruckTypeRepository(new TruckType());
        });

        $this->app->singleton(TruckRepository::class, function ($app) {
            return new TruckRepository(new Truck());
        });

        $this->app->singleton(DriverRepository::class, function ($app) {
            return new DriverRepository(new Driver());
        });

        $this->app->singleton(LocationRepository::class, function ($app) {
            return new LocationRepository(new Location());
        });

        $this->app->singleton(RouteRepository::class, function ($app) {
            return new RouteRepository(new Route());
        });

        $this->app->singleton(TruckLoadoutRepository::class, function ($app) {
            return new TruckLoadoutRepository(new TruckLoadout());
        });

        $this->app->singleton(PriceRepository::class, function ($app) {
            return new PriceRepository(new Price());
        });

        $this->app->singleton(UserRepository::class, function ($app) {
            return new UserRepository(new User());
        });

        $this->app->singleton(RoleRepository::class, function ($app) {
            return new RoleRepository(new Role());
        });

        $this->app->singleton(AccountTypeRepository::class, function ($app) {
            return new AccountTypeRepository(new AccountType());
        });

        $this->app->singleton(AccountCategoryRepository::class, function ($app) {
            return new AccountCategoryRepository(new AccountCategory());
        });

        $this->app->singleton(AccountRepository::class, function ($app) {
            return new AccountRepository(new Account());
        });

        $this->app->singleton(QuotationRepository::class, function ($app) {
            return new QuotationRepository(new Transaction());
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
