<?php

namespace App\Repositories;

use App\Models\Account;
use App\Repositories\BaseRepository;

class AccountRepository extends BaseRepository
{
    /**
     * AccountRepository constructor.
     *
     * @param Account $model
     */
    public function __construct(Account $model)
    {
        parent::__construct($model);
    }

    /**
     * Get account with relationships
     *
     * @param int $id
     * @return Account
     */
    public function findWithRelations(int $id): Account
    {
        return $this->model->with(['category', 'type'])->findOrFail($id);
    }
}
