<?php

namespace App\Repositories;

use App\Models\Customer;
use App\Repositories\BaseRepository;

class CustomerRepository extends BaseRepository
{
    /**
     * CustomerRepository constructor.
     *
     * @param Customer $model
     */
    public function __construct(Customer $model)
    {
        parent::__construct($model);
    }

    /**
     * Create customer with specific logic
     *
     * @param array $data
     * @return Customer
     */
    public function createCustomer(array $data): Customer
    {
        // Set default status if not provided
        if (!isset($data['status'])) {
            $data['status'] = true;
        }

        return $this->create($data);
    }
}
