<?php

namespace App\Repositories;

use App\Models\Price;
use App\Repositories\BaseRepository;

class PriceRepository extends BaseRepository
{
    /**
     * PriceRepository constructor.
     *
     * @param Price $model
     */
    public function __construct(Price $model)
    {
        parent::__construct($model);
    }

    /**
     * Get price with all relationships
     *
     * @param int $id
     * @return Price
     */
    public function findWithRelations(int $id): Price
    {
        return $this->model->with(['route', 'loadout', 'customer'])->findOrFail($id);
    }
}
