<?php

namespace App\Repositories;

use App\Models\Route;
use App\Repositories\BaseRepository;

class RouteRepository extends BaseRepository
{
    /**
     * RouteRepository constructor.
     *
     * @param Route $model
     */
    public function __construct(Route $model)
    {
        parent::__construct($model);
    }

    /**
     * Get route with location relationships
     *
     * @param int $id
     * @return Route
     */
    public function findWithLocations(int $id): Route
    {
        return $this->model->with(['origin', 'destination'])->findOrFail($id);
    }
}
