<?php

namespace App\Repositories;

use App\Models\Truck;
use App\Repositories\BaseRepository;

class TruckRepository extends BaseRepository
{
    /**
     * TruckRepository constructor.
     *
     * @param Truck $model
     */
    public function __construct(Truck $model)
    {
        parent::__construct($model);
    }

    /**
     * Get truck with type relationship
     *
     * @param int $id
     * @return Truck
     */
    public function findWithType(int $id): Truck
    {
        return $this->model->with('type')->findOrFail($id);
    }
}
