<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Resource Modules
    |--------------------------------------------------------------------------
    |
    | Define all resource modules with their display labels.
    | These will be used to generate the standard CRUD permissions.
    |
    | Format: 'resource-key' => 'Display Label'
    |
    */

    'resources' => [
        'customer' => 'Customer',
        'truck' => 'Truck',
        'truck-type' => 'Truck Type',
        'truck-loadout' => 'Truck Loadout',
        'user' => 'User',
        'role' => 'Role',
        'driver' => 'Driver',
        'route' => 'Route',
        'location' => 'Location',
        'price' => 'Price',
        'account-category' => 'Account Category',
        'account-type' => 'Account Type',
        'account' => 'Account',
        'journal' => 'Journal',
        'quotation' => 'Quotation',
        'sales-order' => 'Sales Order',
        'delivery-order' => 'Delivery Order',
        'config' => 'Config',
        'activity-log' => 'Activity Log',
        // Add more resources here as needed
    ],

    /*
    |--------------------------------------------------------------------------
    | Excluded Permissions
    |--------------------------------------------------------------------------
    |
    | Exclude specific permissions from being shown in the role form.
    | This is useful for hiding internal or system-only permissions.
    |
    | Format: ['resource.action', 'resource.action']
    |
    | Examples:
    | - Exclude specific action: 'customer.destroy'
    | - Exclude all actions for a resource: 'customer.*'
    | - Exclude specific action across all resources: '*.data'
    |
    */

    'excluded_permissions' => [
        // Exclude all .data routes (AJAX endpoints)
        '*.data',
        'sales-order.create',
        'activity-log.create',
        'activity-log.store',
        'activity-log.edit',
        'activity-log.update',
        'activity-log.destroy',
        // '*.create',
        // '*.edit'
        // Example: Exclude delete for specific resources
        // 'role.destroy',
        // 'user.destroy',

        // Example: Exclude entire resource from permissions
        // 'system-log.*',
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Permissions
    |--------------------------------------------------------------------------
    |
    | Define custom permissions for each resource module.
    | These are non-CRUD permissions that are specific to your application.
    |
    | Format:
    | 'resource-key' => [
    |     'action-name' => 'Display Label',
    | ]
    |
    */

    'custom_permissions' => [
        'quotation' => [
            'approve' => 'Approve Quotation',
            'reject' => 'Reject Quotation'
        ],
    ],

];
