<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_route')->constrained('routes')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_loadout')->constrained('truck_loadouts')->onDelete('no action')->onUpdate('no action');
            $table->decimal('price', 17, 2);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_loadout', 'fk_routes_has_truck_loadout_truck_load_idx');
            $table->index('id_route', 'fk_routes_has_truck_loadout_routes1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prices');
    }
};
