<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_customer')->constrained('customers')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_sales')->constrained('users')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_transaction')->constrained('transactions')->onDelete('no action')->onUpdate('no action');
            $table->string('code', 64);
            $table->date('invoice_date');
            $table->decimal('ppn', 17, 2);
            $table->decimal('pph', 17, 2);
            $table->decimal('discount', 17, 2);
            $table->decimal('total', 17, 2);
            $table->decimal('grand_total', 17, 2)->nullable();
            $table->enum('type', ['quotation', 'salesorder'])->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected', 'onprogress', 'done', 'paid'])->nullable()->default('pending');
            $table->mediumText('notes')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_customer', 'fk_transactions_customers1_idx');
            $table->index('id_sales', 'fk_transactions_users1_idx');
            $table->index('id_transaction', 'fk_transactions_transactions1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
