<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transaction_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_transaction')->constrained('transactions')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_origin')->constrained('locations')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_destination')->constrained('locations')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_loadout')->constrained('truck_loadouts')->onDelete('no action')->onUpdate('no action');
            $table->decimal('price', 17, 2);
            $table->decimal('sub_total', 17, 2);
            $table->integer('quantity');
            $table->enum('origin_action', ['unload', 'load']);
            $table->enum('destination_action', ['unload', 'load']);
            $table->mediumText('notes')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_transaction', 'fk_transaction_details_transactions1_idx');
            $table->index('id_origin', 'fk_transaction_details_locations1_idx');
            $table->index('id_destination', 'fk_transaction_details_locations2_idx');
            $table->index('id_loadout', 'fk_transaction_details_truck_loadout1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transaction_details');
    }
};
