<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_category')->constrained('account_categories')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_type')->constrained('account_types')->onDelete('no action')->onUpdate('no action');
            $table->string('name', 255);
            $table->string('code', 16);
            $table->enum('nature', ['debit', 'credit']);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_category', 'fk_accounts_account_categories1_idx');
            $table->index('id_type', 'fk_accounts_account_types1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};
