<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('account_journals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_journal')->constrained('journals')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_accounts')->constrained('accounts')->onDelete('no action')->onUpdate('no action');
            $table->string('code', 64)->nullable();

            $table->index('id_accounts', 'fk_account_journals_accounts1_idx');
            $table->index('id_journal', 'fk_account_journals_journals1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('account_journals');
    }
};
