<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->string('code', 64);
            $table->date('invoice_date');
            $table->decimal('total', 17, 2);
            $table->decimal('total_discount', 17, 2);
            $table->decimal('total_ppn', 17, 2);
            $table->decimal('total_pph', 17, 2);
            $table->decimal('grand_total', 17, 2);
            $table->enum('status', ['pending', 'paid', 'verified', 'closed'])->default('pending');
            $table->foreignId('id_payment_account')->constrained('accounts')->onDelete('no action')->onUpdate('no action');
            $table->mediumText('notes')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_payment_account', 'fk_invoices_accounts1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
