<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('deliver_order_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_delivery_order')->constrained('delivery_orders')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_detail')->constrained('transaction_details')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_driver')->constrained('drivers')->onDelete('no action')->onUpdate('no action');
            $table->foreignId('id_truck')->constrained('trucks')->onDelete('no action')->onUpdate('no action');
            $table->date('delivery_date');
            $table->enum('status', ['pending', 'loading', 'unloading', 'ondelivery', 'onhold', 'finish'])->default('pending');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_delivery_order', 'fk_deliver_order_details_delivery_order1_idx');
            $table->index('id_detail', 'fk_deliver_order_details_transaction_details1_idx');
            $table->index('id_driver', 'fk_deliver_order_details_drivers1_idx');
            $table->index('id_truck', 'fk_deliver_order_details_trucks1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('deliver_order_details');
    }
};
