<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_order_status_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_delivery_order_detail')->constrained('deliver_order_details')->onDelete('no action')->onUpdate('no action');
            $table->enum('status', ['pending', 'loading', 'unloading', 'ondelivery', 'onhold', 'finish']);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_delivery_order_detail', 'fk_delivery_order_status_log_deliver_order_details1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery_order_status_logs');
    }
};
