<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_order_files', function (Blueprint $table) {
            $table->id();
            $table->foreignId('id_delivery_detail_log_status')->constrained('delivery_order_status_logs')->onDelete('no action')->onUpdate('no action');
            $table->string('name', 45);
            $table->enum('type', ['loading', 'unloading', 'onhold']);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->integer('created_by');
            $table->integer('updated_by')->nullable();
            $table->integer('deleted_by')->nullable();

            $table->index('id_delivery_detail_log_status', 'fk_delivery_order_file_delivery_order_status_log1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery_order_files');
    }
};
