<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->string('code', 16)->after('id');
            $table->string('kk_number', 16)->nullable()->after('license_number');
            $table->string('bpjs_number', 16)->nullable()->after('kk_number');
            $table->enum('license_type', ['B1', 'B1 UMUM', 'B2', 'B2 UMUM'])->after('license_file');
            $table->date('license_date')->after('license_type');
            $table->string('kk_file', 45)->nullable()->after('license_date');
            $table->string('photo_file', 45)->after('kk_file');
            $table->string('skck_file', 45)->nullable()->after('photo_file');
            $table->string('bank_name', 45)->nullable()->after('skck_file');
            $table->string('bank_owner_name', 45)->nullable()->after('bank_name');
            $table->string('bank_no', 45)->nullable()->after('bank_owner_name');
            $table->enum('status', ['active', 'blacklist', 'resigned'])->default('active')->after('joined_date');
            $table->string('notes', 512)->nullable()->after('status');
            $table->dropColumn('birth_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->dropColumn(['code', 'kk_number', 'bpjs_number', 'license_type', 'license_date', 'kk_file', 'photo_file', 'skck_file', 'bank_name', 'bank_owner_name', 'bank_no', 'status', 'notes']);
            $table->date('birth_date')->after('joined_date');
        });
    }
};
