<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->string('code', 16)->nullable()->after('id_type');
            $table->string('brand', 64)->nullable()->after('code');
            $table->string('body_no', 45)->nullable()->after('brand');
            $table->string('machine_no', 45)->nullable()->after('body_no');
            $table->string('vehicle_year', 4)->nullable()->after('machine_no');
            $table->string('stnk_owner', 255)->nullable()->after('vehicle_year');
            $table->string('kir_name', 255)->nullable()->after('stnk_owner');
            $table->date('stnk_date')->nullable()->after('kir_date');
            $table->date('credit_start_date')->nullable()->after('stnk_file');
            $table->date('credit_end_date')->nullable()->after('credit_start_date');
            $table->string('cctv_gps_no', 32)->nullable()->after('credit_end_date');
            $table->string('gps_contact', 16)->nullable()->after('cctv_gps_no');
            $table->string('note', 255)->nullable()->after('gps_contact');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->dropColumn(['code', 'brand', 'body_no', 'machine_no', 'vehicle_year', 'stnk_owner', 'kir_name', 'stnk_date', 'credit_start_date', 'credit_end_date', 'cctv_gps_no', 'gps_contact', 'note']);
        });
    }
};
