<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('prices', function (Blueprint $table) {
            $table->foreignId('id_customer')->nullable()->after('id_loadout')->constrained('customers')->onDelete('no action')->onUpdate('no action');
            $table->index('id_customer', 'fk_prices_customers1_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('prices', function (Blueprint $table) {
            $table->dropForeign(['id_customer']);
            $table->dropIndex('fk_prices_customers1_idx');
            $table->dropColumn('id_customer');
        });
    }
};
