<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transaction_details', function (Blueprint $table) {
            $table->decimal('pocket_money_1', 17, 2)->after('price');
            $table->decimal('pocket_money_2', 17, 2)->nullable()->after('pocket_money_1');
            $table->decimal('pocket_money_3', 17, 2)->nullable()->after('pocket_money_2');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transaction_details', function (Blueprint $table) {
            $table->dropColumn(['pocket_money_1', 'pocket_money_2', 'pocket_money_3']);
        });
    }
};
