<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->string('kir_file', 45)->nullable()->change();
            $table->string('bpkb_file', 45)->nullable()->change();
            $table->string('stnk_file', 45)->nullable()->change();
            $table->date('tax_date')->nullable()->change();
            $table->date('kir_date')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trucks', function (Blueprint $table) {
            $table->string('kir_file', 45)->nullable(false)->change();
            $table->string('bpkb_file', 45)->nullable(false)->change();
            $table->string('stnk_file', 45)->nullable(false)->change();
            $table->date('tax_date')->nullable(false)->change();
            $table->date('kir_date')->nullable(false)->change();
        });
    }
};
