<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->string('identity_file', 255)->change();
            $table->string('license_file', 255)->change();
            $table->string('kk_file', 255)->nullable()->change();
            $table->string('photo_file', 255)->change();
            $table->string('skck_file', 255)->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('drivers', function (Blueprint $table) {
            $table->string('identity_file', 45)->change();
            $table->string('license_file', 45)->change();
            $table->string('kk_file', 45)->nullable()->change();
            $table->string('photo_file', 45)->change();
            $table->string('skck_file', 45)->nullable()->change();
        });
    }
};
