<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deliver_order_details', function (Blueprint $table) {
            $table->string('driver_access_token', 64)->unique()->nullable()->after('status');
            $table->timestamp('token_expires_at')->nullable()->after('driver_access_token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deliver_order_details', function (Blueprint $table) {
            $table->dropColumn(['driver_access_token', 'token_expires_at']);
        });
    }
};
