<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->decimal('ppn_percentage', 5, 2)->default(0)->after('ppn')->comment('PPN percentage at time of transaction');
            $table->decimal('pph_percentage', 5, 2)->default(0)->after('pph')->comment('PPH percentage at time of transaction');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn(['ppn_percentage', 'pph_percentage']);
        });
    }
};
