/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { type ValidateFunctionInterface, type ValidateOptions, type ValidateResult } from '@form-validation/core';

export interface RemoteOptions extends ValidateOptions {
    url: string;
    // Does it request to other domain? Default value is `false`
    crossDomain?: boolean;
    // By default, it will take the value `{ <fieldName>: <fieldValue> }`
    data?: Record<string, unknown> | ((...arg: unknown[]) => unknown);
    // Additional headers
    headers?: {
        [name: string]: string;
    };
    // Override the field name for the request
    name?: string;
    // Can be GET or POST (default)
    method?: string;
    // The valid key. It's `valid` by default
    // This is useful when connecting to external remote server or APIs provided by 3rd parties
    validKey?: string;
}

export function remote(): ValidateFunctionInterface<RemoteOptions, Promise<ValidateResult>>;
