/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface StringLengthOptions extends ValidateOptions {
    // At least one of two options is required
    // The min, max keys define the number which the field value compares to. min, max can be
    // - A number
    // - Name of field which its value defines the number
    // - Name of callback function that returns the number
    // - A callback function that returns the number
    max?: number | string;
    min?: number | string;
    // Indicate the length will be calculated after trimming the value or not. It is false, by default
    trim?: boolean | string;
    // Evaluate string length in UTF-8 bytes, default to false
    utf8Bytes?: boolean | string;
}
export interface StringLengthLocalization extends Localization {
    stringLength: {
        between: string;
        default: string;
        less: string;
        more: string;
    };
}

export function stringLength(): ValidateFunctionInterface<StringLengthOptions, ValidateResult>;
