/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { type ValidateFunctionInterface, type ValidateOptions, type ValidateResult } from '@form-validation/core';

export interface UriOptions extends ValidateOptions {
    // Allow the URI without protocol. Default to false
    allowEmptyProtocol?: boolean | string;
    // Allow the private and local network IP. Default to false
    allowLocal?: boolean | string;
    // The protocols, separated by a comma. Default to "http, https, ftp"
    protocol?: string;
}

export function uri(): ValidateFunctionInterface<UriOptions, ValidateResult>;
