'use strict';

const svg_index = require('./svg/index.cjs');
const svg_parse = require('./svg/parse.cjs');
const svg_parseStyle = require('./svg/parse-style.cjs');
const svg_analyse = require('./svg/analyse.cjs');
const svg_cleanup = require('./svg/cleanup.cjs');
const svg_cleanup_attribs = require('./svg/cleanup/attribs.cjs');
const svg_cleanup_badTags = require('./svg/cleanup/bad-tags.cjs');
const svg_cleanup_rootStyle = require('./svg/cleanup/root-style.cjs');
const svg_cleanup_inlineStyle = require('./svg/cleanup/inline-style.cjs');
const svg_cleanup_rootSvg = require('./svg/cleanup/root-svg.cjs');
const svg_cleanup_svgoStyle = require('./svg/cleanup/svgo-style.cjs');
const iconSet_index = require('./icon-set/index.cjs');
const iconSet_merge = require('./icon-set/merge.cjs');
const iconSet_tags = require('./icon-set/tags.cjs');
const import_figma_index = require('./import/figma/index.cjs');
const import_directory = require('./import/directory.cjs');
const download_git_index = require('./download/git/index.cjs');
const download_git_hash = require('./download/git/hash.cjs');
const download_git_branch = require('./download/git/branch.cjs');
const download_git_reset = require('./download/git/reset.cjs');
const download_github_index = require('./download/github/index.cjs');
const download_github_hash = require('./download/github/hash.cjs');
const download_gitlab_index = require('./download/gitlab/index.cjs');
const download_gitlab_hash = require('./download/gitlab/hash.cjs');
const download_npm_index = require('./download/npm/index.cjs');
const download_npm_version = require('./download/npm/version.cjs');
const download_index = require('./download/index.cjs');
const download_api_download = require('./download/api/download.cjs');
const colors_parse = require('./colors/parse.cjs');
const colors_validate = require('./colors/validate.cjs');
const colors_detect = require('./colors/detect.cjs');
const optimise_svgo = require('./optimise/svgo.cjs');
const optimise_figma = require('./optimise/figma.cjs');
const optimise_flags = require('./optimise/flags.cjs');
const optimise_origin = require('./optimise/origin.cjs');
const optimise_mask = require('./optimise/mask.cjs');
const optimise_scale = require('./optimise/scale.cjs');
const optimise_globalStyle = require('./optimise/global-style.cjs');
const export_directory = require('./export/directory.cjs');
const export_jsonPackage = require('./export/json-package.cjs');
const export_iconPackage = require('./export/icon-package.cjs');
const misc_writeJson = require('./misc/write-json.cjs');
const export_helpers_prepare = require('./export/helpers/prepare.cjs');
const misc_scan = require('./misc/scan.cjs');
const misc_compareDirs = require('./misc/compare-dirs.cjs');
const download_helpers_unzip = require('./download/helpers/unzip.cjs');
const download_helpers_untar = require('./download/helpers/untar.cjs');
const misc_exec = require('./misc/exec.cjs');
const misc_keyword = require('./misc/keyword.cjs');
const misc_bumpVersion = require('./misc/bump-version.cjs');
const download_api_config = require('./download/api/config.cjs');
const download_api_index = require('./download/api/index.cjs');
const download_api_queue = require('./download/api/queue.cjs');
require('cheerio');
require('@iconify/utils');
require('./css/parse.cjs');
require('./css/parser/tokens.cjs');
require('./css/parser/error.cjs');
require('./css/parser/strings.cjs');
require('./css/parser/text.cjs');
require('./css/parser/export.cjs');
require('./css/parser/tree.cjs');
require('./svg/data/attributes.cjs');
require('./svg/data/tags.cjs');
require('./svg/analyse/error.cjs');
require('@iconify/utils/lib/icon/defaults');
require('@iconify/utils/lib/svg/build');
require('@iconify/utils/lib/icon-set/minify');
require('@iconify/utils/lib/icon-set/convert-info');
require('./icon-set/props.cjs');
require('@iconify/utils/lib/misc/objects');
require('./icon-set/match.cjs');
require('./icon-set/modified.cjs');
require('./import/figma/nodes.cjs');
require('./import/figma/query.cjs');
require('./download/api/cache.cjs');
require('fs');
require('crypto');
require('svgo');
require('@iconify/utils/lib/svg/id');
require('@iconify/utils/lib/colors');
require('axios');
require('pathe');
require('fs/promises');
require('extract-zip');
require('tar');
require('./download/gitlab/types.cjs');
require('./colors/attribs.cjs');
require('./optimise/unwrap.cjs');
require('./export/helpers/custom-files.cjs');
require('child_process');



exports.SVG = svg_index.SVG;
exports.parseSVG = svg_parse.parseSVG;
exports.parseSVGStyle = svg_parseStyle.parseSVGStyle;
exports.analyseSVGStructure = svg_analyse.analyseSVGStructure;
exports.cleanupSVG = svg_cleanup.cleanupSVG;
exports.removeBadAttributes = svg_cleanup_attribs.removeBadAttributes;
exports.checkBadTags = svg_cleanup_badTags.checkBadTags;
exports.cleanupRootStyle = svg_cleanup_rootStyle.cleanupRootStyle;
exports.cleanupInlineStyle = svg_cleanup_inlineStyle.cleanupInlineStyle;
exports.cleanupSVGRoot = svg_cleanup_rootSvg.cleanupSVGRoot;
exports.convertStyleToAttrs = svg_cleanup_svgoStyle.convertStyleToAttrs;
exports.IconSet = iconSet_index.IconSet;
exports.blankIconSet = iconSet_index.blankIconSet;
exports.mergeIconSets = iconSet_merge.mergeIconSets;
exports.addTagsToIconSet = iconSet_tags.addTagsToIconSet;
exports.importFromFigma = import_figma_index.importFromFigma;
exports.importDirectory = import_directory.importDirectory;
exports.importDirectorySync = import_directory.importDirectorySync;
exports.downloadGitRepo = download_git_index.downloadGitRepo;
exports.getGitRepoHash = download_git_hash.getGitRepoHash;
exports.getGitRepoBranch = download_git_branch.getGitRepoBranch;
exports.resetGitRepoContents = download_git_reset.resetGitRepoContents;
exports.downloadGitHubRepo = download_github_index.downloadGitHubRepo;
exports.getGitHubRepoHash = download_github_hash.getGitHubRepoHash;
exports.downloadGitLabRepo = download_gitlab_index.downloadGitLabRepo;
exports.getGitLabRepoHash = download_gitlab_hash.getGitLabRepoHash;
exports.downloadNPMPackage = download_npm_index.downloadNPMPackage;
exports.getNPMVersion = download_npm_version.getNPMVersion;
exports.getPackageVersion = download_npm_version.getPackageVersion;
exports.downloadPackage = download_index.downloadPackage;
exports.downloadFile = download_api_download.downloadFile;
exports.isEmptyColor = colors_parse.isEmptyColor;
exports.parseColors = colors_parse.parseColors;
exports.validateColors = colors_validate.validateColors;
exports.detectIconSetPalette = colors_detect.detectIconSetPalette;
exports.runSVGO = optimise_svgo.runSVGO;
exports.removeFigmaClipPathFromSVG = optimise_figma.removeFigmaClipPathFromSVG;
exports.deOptimisePaths = optimise_flags.deOptimisePaths;
exports.resetSVGOrigin = optimise_origin.resetSVGOrigin;
exports.convertSVGToMask = optimise_mask.convertSVGToMask;
exports.scaleSVG = optimise_scale.scaleSVG;
exports.cleanupGlobalStyle = optimise_globalStyle.cleanupGlobalStyle;
exports.exportToDirectory = export_directory.exportToDirectory;
exports.exportJSONPackage = export_jsonPackage.exportJSONPackage;
exports.exportIconPackage = export_iconPackage.exportIconPackage;
exports.writeJSONFile = misc_writeJson.writeJSONFile;
exports.prepareDirectoryForExport = export_helpers_prepare.prepareDirectoryForExport;
exports.scanDirectory = misc_scan.scanDirectory;
exports.scanDirectorySync = misc_scan.scanDirectorySync;
exports.compareDirectories = misc_compareDirs.compareDirectories;
exports.unzip = download_helpers_unzip.unzip;
exports.untar = download_helpers_untar.untar;
exports.execAsync = misc_exec.execAsync;
exports.cleanupIconKeyword = misc_keyword.cleanupIconKeyword;
exports.bumpVersion = misc_bumpVersion.bumpVersion;
exports.axiosConfig = download_api_config.axiosConfig;
exports.fetchCallbacks = download_api_config.fetchCallbacks;
exports.sendAPIQuery = download_api_index.sendAPIQuery;
exports.defaultQueueParams = download_api_queue.defaultQueueParams;
exports.runConcurrentQueries = download_api_queue.runConcurrentQueries;
